<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class ClaimSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        $validStatuses = [
            'pending', 'under_review', 'approved', 'rejected', 'paid', 'closed'
        ];

        $policies = DB::table('policies')
            ->select('id', 'policy_number', 'customer_id', 'corporate_customer_id')
            ->get();

        $lastClaimId = DB::table('claims')->max('id') ?? 0;

        foreach ($policies as $index => $policy) {
            // Ensure dates are from 2024 onward
            $incidentDate = $faker->dateTimeBetween('2024-01-01', 'now');
            $submittedAt = $faker->dateTimeBetween($incidentDate, 'now');

            $claimStatus = $faker->randomElement($validStatuses);

            $reviewedAt = in_array($claimStatus, ['under_review', 'approved', 'rejected', 'paid', 'closed'])
                ? $faker->dateTimeBetween($submittedAt, 'now')
                : null;

            $approvedAt = in_array($claimStatus, ['approved', 'paid', 'closed'])
                ? $faker->dateTimeBetween($reviewedAt ?? $submittedAt, 'now')
                : null;

            $settledAt = in_array($claimStatus, ['paid', 'closed'])
                ? $faker->dateTimeBetween($approvedAt ?? $submittedAt, 'now')
                : null;

            $claimAmountRequested = $faker->randomFloat(2, 10000, 1000000);
            $deductible = $faker->randomFloat(2, 0, 5000);

            $claimAmountApproved = in_array($claimStatus, ['approved', 'paid', 'closed'])
                ? $claimAmountRequested - $deductible
                : null;

            $settlementAmount = in_array($claimStatus, ['paid', 'closed'])
                ? $claimAmountApproved
                : null;

            $claimNumber = 'CLM-' . str_pad($lastClaimId + $index + 1, 8, '0', STR_PAD_LEFT);

            DB::table('claims')->insert([
                'customer_id' => $policy->customer_id,
                'corporate_customer_id' => $policy->corporate_customer_id,
                'policy_id' => $policy->id,
                'policy_number' => $policy->policy_number,
                'claim_number' => $claimNumber,
                'claim_type' => $faker->randomElement(['accident', 'theft', 'fire', 'natural_disaster']),
                'incident_date' => $incidentDate->format('Y-m-d'),
                'incident_location' => $faker->latitude . ', ' . $faker->longitude,
                'incident_description' => $faker->sentence,
                'claim_amount_requested' => $claimAmountRequested,
                'claim_amount_approved' => $claimAmountApproved,
                'deductible' => $deductible,
                'settlement_amount' => $settlementAmount,
                'claim_status' => $claimStatus,
                'submitted_at' => $submittedAt,
                'reviewed_at' => $reviewedAt,
                'approved_at' => $approvedAt,
                'settled_at' => $settledAt,
                'supporting_documents' => null,
                'adjuster_notes' => null,
                'assigned_adjuster' => 'Addisalem',
                'created_by' => 2,
                'updated_by' => 2,
                'created_at' => now(),
                'updated_at' => now(),
                'deleted_at' => null,
            ]);
        }
    }
}
